/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MakeTangentLineCircle.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"

HRESULT MakeTangentLineCircle(ILine *line1, ILine *circle1)
{

	//	Creates a Tangent constraint between the given line and the given circle

	START_METHOD("MakeTangentLineCircle")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IObject *object = CAST(IObject, line1);

	// Get the parent workplane of the object
	IObject *parentWorkplane = NULL;

	status = CAST(IObject, line1)->GetParent(GetBSTR("Workplane"), &parentWorkplane);
	CHECK_RETURN_STATUS(status)

	ITangent *pTangent = NULL;
	status = (GetCLASS(Tangent))->CreateTangent(CAST(ILine, line1), CAST(ILine, circle1), &pTangent);
	CHECK_RETURN_STATUS(status)

	IConstraint *pConstraint1 = NULL;

	status = CAST(IWorkplane, parentWorkplane)->GetConstraint(CAST(IGeomConstraint, pTangent), &pConstraint1);
	CHECK_RETURN_STATUS(status)

	if(pConstraint1) {
		pTangent->Release();
	}
	else {
			IConstraint *pConstraint2 = NULL;
			status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint, pTangent), &pConstraint2);
			CHECK_RETURN_STATUS(status)
	}

	END_METHOD("MakeTangentLineCircle")
}
